//
//  Displaying_Pins_on_a_Map_ViewViewController.m
//  Displaying Pins on a Map View
//
//  Created by Vandad Nahavandipoor on 14/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Displaying_Pins_on_a_Map_ViewViewController.h"
#import "MyAnnotation.h"

@implementation Displaying_Pins_on_a_Map_ViewViewController

@synthesize myMapView;

- (void)didReceiveMemoryWarning
{
  [super didReceiveMemoryWarning];
  // Usunięcie wszelkich buforowanych danych, obrazów itd., które nie są obecnie używane.
}

- (void)viewDidLoad {
  [super viewDidLoad];
  
  /* Utworzenie mapy wypełniającej cały ekran. */
  self.myMapView = [[MKMapView alloc] 
                    initWithFrame:self.view.bounds];
  
  self.myMapView.delegate = self;
  
  /* Tworzona mapa ma być standardowa. */
  self.myMapView.mapType = MKMapTypeStandard;
  
  self.myMapView.autoresizingMask = 
    UIViewAutoresizingFlexibleWidth |
    UIViewAutoresizingFlexibleHeight;
  
  /* Dodanie mapy do widoku. */
  [self.view addSubview:self.myMapView];
  
  /* To tylko przykładowe położenie. */
  CLLocationCoordinate2D location = 
    CLLocationCoordinate2DMake(50.288865, 18.662042);
  
  /* Utworzenie opisu na podstawie położenia. */
  MyAnnotation *annotation = 
  [[MyAnnotation alloc] initWithCoordinates:location
                                      title:@"Gliwice"
                                   subTitle:@"Wydawnictwo Helion"];
  
  /* Umieszczenie opisu na mapie. */
  [self.myMapView addAnnotation:annotation];
  
}

- (void) viewDidUnload{
  [super viewDidUnload];
  self.myMapView = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation
        :(UIInterfaceOrientation)interfaceOrientation{
  return YES;
}

@end
